---
generated_at: 2026-02-02 10:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：21-Garbage Collectorコントローラー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **デフォルトワーカー数20**：kube-controller-managerの起動パラメータによるため、コード上のデフォルト値の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `pkg/controller/garbagecollector/garbagecollector.go` 64-77行目（GarbageCollector構造体）
- E-02: `pkg/controller/garbagecollector/garbagecollector.go` 83-119行目（コンストラクタ）
- E-03: `pkg/controller/garbagecollector/garbagecollector.go` 132-181行目（Run関数）
- E-04: `pkg/controller/garbagecollector/garbagecollector.go` 190-264行目（Sync関数）
- E-05: `pkg/controller/garbagecollector/garbagecollector.go` 288-378行目（attemptToDeleteWorker）
- E-06: `pkg/controller/garbagecollector/garbagecollector.go` 383-456行目（isDangling）
- E-07: `pkg/controller/garbagecollector/garbagecollector.go` 464-487行目（classifyReferences）
- E-08: `pkg/controller/garbagecollector/garbagecollector.go` 503-651行目（attemptToDeleteItem）
- E-09: `pkg/controller/garbagecollector/garbagecollector.go` 654-670行目（processDeletingDependentsItem）
- E-10: `pkg/controller/garbagecollector/garbagecollector.go` 673-709行目（orphanDependents）
- E-11: `pkg/controller/garbagecollector/garbagecollector.go` 711-765行目（attemptToOrphanWorker）
- E-12: `pkg/controller/garbagecollector/garbagecollector.go` 786-817行目（GetDeletableResources）
- E-13: `pkg/controller/garbagecollector/graph.go` 29-33行目（objectReference構造体）
- E-14: `pkg/controller/garbagecollector/graph.go` 63-80行目（node構造体）
- E-15: `pkg/controller/garbagecollector/graph_builder.go` 68-76行目（event構造体）
- E-16: `pkg/controller/garbagecollector/graph_builder.go` 81-100行目（GraphBuilder構造体）
- E-17: `pkg/controller/garbagecollector/garbagecollector.go` 51行目（ResourceResyncTime定数）
- E-18: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 24行目（kubectl delete連携）
- E-19: `docs/code-to-docs/機能一覧/機能一覧.csv` 22行目（機能説明）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GCはOwnerReferenceに基づくカスケード削除を行う | E-08, E-19 | ○ |
| C-02 | GarbageCollector構造体はattemptToDelete/attemptToOrphanの2つのキューを持つ | E-01 | ○ |
| C-03 | GraphBuilderが依存関係グラフを構築する | E-16 | ○ |
| C-04 | Run()でEventBroadcaster開始しGraphBuilder起動 | E-03 | ○ |
| C-05 | 初期同期タイムアウトがある | E-03 (158-167行目) | ○ |
| C-06 | attemptToDeleteとattemptToOrphanでworkers個ずつワーカー起動 | E-03 (172-179行目) | ○ |
| C-07 | classifyReferencesがsolid/dangling/waitingForDependentsDeletionに分類 | E-07 | ○ |
| C-08 | isDanglingがabsentOwnerCacheを使用 | E-06 (388-405行目) | ○ |
| C-09 | クラスタースコープがNamespacedオーナーを参照するとエラー | E-06 (421-429行目) | ○ |
| C-10 | 削除ポリシーはFinalizer基づいて決定される | E-08 (633-644行目) | ○ |
| C-11 | orphanDependentsは並行goroutineで処理する | E-10 (674-696行目) | ○ |
| C-12 | Syncは定期的にDiscovery APIをポーリングする | E-04 | ○ |
| C-13 | GetDeletableResourcesはdelete/list/watchサポートリソースを対象 | E-12 (803行目) | ○ |
| C-14 | ResourceResyncTimeは0 | E-17 | ○ |
| C-15 | kubectl deleteとAPI連携がある | E-18 | ○ |
| C-16 | NotFound時は仮想削除イベントを発行 | E-08 (523-531行目) | ○ |
| C-17 | UID不一致時も仮想削除イベントを発行 | E-08 (536-542行目) | ○ |
| C-18 | Strategic Merge PatchからJSON Merge Patchへのフォールバック | E-08 (592-594行目) | ○ |
| C-19 | node構造体は各フィールドに個別のRWMutexを持つ | E-14 | ○ |
| C-20 | event構造体はvirtual/eventType/obj/gvkを持つ | E-15 | ○ |
| C-21 | processDeletingDependentsItemでblockingDependentsが0ならFinalizer除去 | E-09 | ○ |
| C-22 | Foreground削除で循環検出のためblocking解除 | E-08 (596-617行目) | ○ |
| C-23 | Discovery障害時に既存モニターを維持 | E-04 (203-210行目) | ○ |
| C-24 | restMappingErrorはログ出力しリトライ | E-05 (355-366行目) | ○ |
| C-25 | デフォルトワーカー数は20 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-25: ワーカー数のデフォルト値はkube-controller-managerの起動フラグ(`--concurrent-gc-syncs`)で設定されるが、本ソースコード内には定義されていない
  - 候補：`cmd/kube-controller-manager/app/options/` / `pkg/controller/apis/config/` / Kubernetes公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張はソースコードから直接検証可能
- 1: 中リスク - デフォルトワーカー数はkube-controller-manager側の設定に依存

## 6) レビュアーチェックリスト（最小）
- [ ] GarbageCollector構造体の定義がコードと一致しているか確認
- [ ] 削除ポリシー（Background/Foreground/Orphan）の判定ロジックがコードと一致しているか確認
- [ ] GraphBuilderのprocessGraphChangesの動作がコードリーディングガイドと整合しているか確認
- [ ] デフォルトワーカー数をkube-controller-managerの設定で確認
